/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.swing.PImagePanel;
import edu.princeton.swing.PSpacer;
import edu.princeton.swing.PTransparentPanel;
import edu.princeton.toy.TImageManager;
import edu.princeton.toy.TMain;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JWindow;

public class TSplashWindow
extends JWindow {
    private static final Toolkit TOOLKIT = Toolkit.getDefaultToolkit();
    private static final Rectangle TEXT_RECTANGLE = new Rectangle(210, 40, 85, 180);
    private static final String[] TEXT_STRINGS = new String[]{"Author", "  B. Tsang", null, "Advisors", "(to be scrambled)", "(to be scrambled)", "(to be scrambled)", null, "Version", "  " + TMain.getVersion(), null, "Build Date", "  " + TMain.getBuildDate()};
    private static final Font HEADING_LABEL_FONT = new Font("Dialog", 1, 12);
    private static final Font TEXT_LABEL_FONT = new Font("Dialog", 0, 11);
    private static final int SEPARATOR_HEIGHT = 5;
    private static final Color FONT_COLOR = new Color(102, 102, 153);

    public TSplashWindow() {
        Icon icon = TImageManager.getIcon((byte)0, (short)0);
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        PTransparentPanel labelPanel = new PTransparentPanel(new GridBagLayout());
        for (int ctr = 0; ctr < TEXT_STRINGS.length; ++ctr) {
            JComponent label;
            if (TEXT_STRINGS[ctr] != null) {
                label = new JLabel(TEXT_STRINGS[ctr]);
                if (!TEXT_STRINGS[ctr].startsWith("  ")) {
                    label.setFont(HEADING_LABEL_FONT);
                } else {
                    label.setFont(TEXT_LABEL_FONT);
                }
                label.setForeground(FONT_COLOR);
            } else {
                label = new PSpacer(TSplashWindow.TEXT_RECTANGLE.width, 5);
            }
            labelPanel.add((Component)label, new GridBagConstraints(0, ctr, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        labelPanel.add((Component)new PSpacer(1, 1), new GridBagConstraints(0, TEXT_STRINGS.length, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        PImagePanel imagePanel = new PImagePanel(icon, new BorderLayout());
        imagePanel.add((Component)new PSpacer(width, TSplashWindow.TEXT_RECTANGLE.y), "North");
        imagePanel.add((Component)new PSpacer(TSplashWindow.TEXT_RECTANGLE.x, TSplashWindow.TEXT_RECTANGLE.height), "West");
        imagePanel.add((Component)new PSpacer(width, height - TSplashWindow.TEXT_RECTANGLE.y - TSplashWindow.TEXT_RECTANGLE.height), "South");
        imagePanel.add((Component)new PSpacer(width - TSplashWindow.TEXT_RECTANGLE.x - TSplashWindow.TEXT_RECTANGLE.width, TSplashWindow.TEXT_RECTANGLE.height), "East");
        imagePanel.add((Component)labelPanel, "Center");
        this.getContentPane().add(imagePanel);
        Dimension screenSize = TOOLKIT.getScreenSize();
        this.setBounds(screenSize.width / 2 - width / 2, screenSize.height / 2 - height / 2, width, height);
    }

    static {
        switch ((int)(Math.random() * 6.0)) {
            case 0: {
                TSplashWindow.TEXT_STRINGS[4] = "  D. Clark";
                TSplashWindow.TEXT_STRINGS[5] = "  R. Sedgewick";
                TSplashWindow.TEXT_STRINGS[6] = "  K. Wayne";
                break;
            }
            case 1: {
                TSplashWindow.TEXT_STRINGS[4] = "  D. Clark";
                TSplashWindow.TEXT_STRINGS[5] = "  K. Wayne";
                TSplashWindow.TEXT_STRINGS[6] = "  R. Sedgewick";
                break;
            }
            case 2: {
                TSplashWindow.TEXT_STRINGS[4] = "  R. Sedgewick";
                TSplashWindow.TEXT_STRINGS[5] = "  K. Wayne";
                TSplashWindow.TEXT_STRINGS[6] = "  D. Clark";
                break;
            }
            case 3: {
                TSplashWindow.TEXT_STRINGS[4] = "  R. Sedgewick";
                TSplashWindow.TEXT_STRINGS[5] = "  D. Clark";
                TSplashWindow.TEXT_STRINGS[6] = "  K. Wayne";
                break;
            }
            case 4: {
                TSplashWindow.TEXT_STRINGS[4] = "  K. Wayne";
                TSplashWindow.TEXT_STRINGS[5] = "  R. Sedgewick";
                TSplashWindow.TEXT_STRINGS[6] = "  D. Clark";
                break;
            }
            default: {
                TSplashWindow.TEXT_STRINGS[4] = "  K. Wayne";
                TSplashWindow.TEXT_STRINGS[5] = "  D. Clark";
                TSplashWindow.TEXT_STRINGS[6] = "  R. Sedgewick";
            }
        }
    }
}

